/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.external.apigee;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.miroit.sicksu.external.apigee.ApigeeTokenService;
import com.miroit.sicksu.external.apigee.dto.ApigeeTokenErrorResponseDto;
import com.miroit.sicksu.external.apigee.dto.ApigeeTokenResponseDto;
import com.miroit.sicksu.utils.enums.TokenType;
import com.miroit.sicksu.utils.exception.TokenRequestException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

@Service
public class ApigeeTokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApigeeTokenService.class);
    private final WebClient secureWebClient;
    private final Cache<TokenType, String> tokenCache = Caffeine.newBuilder().expireAfterWrite(120L, TimeUnit.MINUTES).maximumSize((long)TokenType.values().length).build();
    @Value(value="${apigee.url}")
    private String apigeeUrl;
    @Value(value="${apigee.employee-client-id}")
    private String employeeClientId;
    @Value(value="${apigee.employee-client-secret}")
    private String employeeClientSecret;
    @Value(value="${apigee.meal-client-id}")
    private String mealClientId;
    @Value(value="${apigee.meal-client-secret}")
    private String mealClientSecret;
    @Value(value="${apigee.workday-client-id}")
    private String workdayClientId;
    @Value(value="${apigee.workday-client-secret}")
    private String workdayClientSecret;

    public String getToken(TokenType tokenType) {
        return (String)this.tokenCache.get((Object)tokenType, arg_0 -> this.fetchToken(arg_0));
    }

    public String fetchToken(TokenType tokenType) {
        String authorizationHeader = switch (1.$SwitchMap$com$miroit$sicksu$utils$enums$TokenType[tokenType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.buildAuthorizationHeader(this.employeeClientId, this.employeeClientSecret);
            case 2 -> this.buildAuthorizationHeader(this.mealClientId, this.mealClientSecret);
            case 3 -> this.buildAuthorizationHeader(this.workdayClientId, this.workdayClientSecret);
        };
        try {
            return (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.secureWebClient.post().uri(this.apigeeUrl, new Object[0])).header("Authorization", new String[]{authorizationHeader})).body((BodyInserter)BodyInserters.fromFormData((String)"grant_type", (String)"client_credentials")).retrieve().onStatus(HttpStatusCode::isError, response -> response.bodyToMono(ApigeeTokenErrorResponseDto.class).doOnNext(error -> log.error("Apigee Token Error Response: {}", error)).then(Mono.error((Throwable)new TokenRequestException("Apigee Token \ubc1c\uae09 \uc2e4\ud328")))).bodyToMono(ApigeeTokenResponseDto.class).map(dto -> dto.getTokenType() + " " + dto.getAccessToken()).block();
        }
        catch (WebClientResponseException e) {
            log.error("WebClient \uc751\ub2f5 \uc624\ub958: status={}, body={}, message={}", new Object[]{e.getStatusCode().value(), e.getResponseBodyAsString(), e.getMessage()});
            throw new TokenRequestException("Apigee \uc694\uccad \uc2e4\ud328", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Apigee \ud1a0\ud070 \uc694\uccad \uc911 \uc608\uc678 \ubc1c\uc0dd: {}", (Object)e.getMessage(), (Object)e);
            throw new TokenRequestException("Apigee \ud1a0\ud070 \ubc1c\uae09 \uc911 \uc608\uc678 \ubc1c\uc0dd", (Throwable)e);
        }
    }

    private String buildAuthorizationHeader(String clientId, String clientSecret) {
        String credentials = clientId + ":" + clientSecret;
        String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        return "Basic " + encoded;
    }

    @Generated
    public ApigeeTokenService(WebClient secureWebClient) {
        this.secureWebClient = secureWebClient;
    }
}

