/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.external.mealmng;

import com.miroit.sicksu.external.apigee.ApigeeTokenService;
import com.miroit.sicksu.meal.domain.dto.request.EmployeeInfoRequestDto;
import com.miroit.sicksu.meal.domain.dto.request.EmployeePhotoRequestDto;
import com.miroit.sicksu.meal.domain.dto.request.MealTimeRequestDto;
import com.miroit.sicksu.meal.domain.dto.request.MealUseRequestDto;
import com.miroit.sicksu.meal.domain.dto.response.EmployeeInfoResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.EmployeePhotoResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.EmployeePhotoWrapperResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.MealTimeResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.MealUseOfflineResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.MealUseResponseDto;
import com.miroit.sicksu.utils.component.WebClientComponent;
import com.miroit.sicksu.utils.enums.RequestType;
import com.miroit.sicksu.utils.enums.TokenType;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class MealMngService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MealMngService.class);
    private final ApigeeTokenService apigeeTokenService;
    private final WebClientComponent webClientComponent;
    @Value(value="${employee.url}")
    private String employeeUrl;
    @Value(value="${meal.url}")
    private String mealUrl;
    @Value(value="${photo.url}")
    private String employeePhotoUrl;

    private String getToken(TokenType type) {
        return this.apigeeTokenService.getToken(type);
    }

    public MealTimeResponseDto mealTime(Integer readerNo) {
        MealTimeRequestDto requestDto = MealTimeRequestDto.builder().readerNo(readerNo).build();
        return (MealTimeResponseDto)this.webClientComponent.post(this.mealUrl + "/set-time", this.getToken(TokenType.MEAL), (Object)requestDto, MealTimeResponseDto.class);
    }

    public EmployeeInfoResponseDto employeeInfo(EmployeeInfoRequestDto requestDto) {
        return (EmployeeInfoResponseDto)this.webClientComponent.post(this.employeeUrl, this.getToken(TokenType.EMPLOYEE), (Object)requestDto, EmployeeInfoResponseDto.class);
    }

    public EmployeePhotoResponseDto employeePhoto(EmployeePhotoRequestDto requestDto) {
        Map<String, String> params = Map.of("eeid", requestDto.getEeid(), "format", "json");
        EmployeePhotoWrapperResponseDto result = (EmployeePhotoWrapperResponseDto)this.webClientComponent.get(RequestType.WORKDAY, this.employeePhotoUrl, this.getToken(TokenType.WORKDAY), params, EmployeePhotoWrapperResponseDto.class);
        if (ObjectUtils.isEmpty((Object)result) || ObjectUtils.isEmpty((Object)result.getReportEntry())) {
            return null;
        }
        return (EmployeePhotoResponseDto)result.getReportEntry().get(0);
    }

    public MealUseResponseDto mealUse(MealUseRequestDto requestDto) {
        return (MealUseResponseDto)this.webClientComponent.post(this.mealUrl + "/use", this.getToken(TokenType.MEAL), (Object)requestDto, MealUseResponseDto.class);
    }

    public MealUseOfflineResponseDto mealUseOffline(List<MealUseRequestDto> requestDtoList) {
        List<Mono> responseMonoList = requestDtoList.stream().map(dto -> Mono.fromCallable(() -> (MealUseResponseDto)this.webClientComponent.post(this.mealUrl + "/use-offline", this.getToken(TokenType.MEAL), dto, MealUseResponseDto.class)).onErrorResume(e -> {
            log.error("\uc624\ud504\ub77c\uc778 API \uc5d0\ub7ec: {}", dto, e);
            return Mono.just((Object)new MealUseResponseDto(1, "\uc5d0\ub7ec \ubc1c\uc0dd", "Error"));
        })).toList();
        List responseList = (List)Flux.merge(responseMonoList).collectList().block();
        return MealUseOfflineResponseDto.builder().resultList(responseList).build();
    }

    @Generated
    public MealMngService(ApigeeTokenService apigeeTokenService, WebClientComponent webClientComponent) {
        this.apigeeTokenService = apigeeTokenService;
        this.webClientComponent = webClientComponent;
    }
}

