/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.meal.controller;

import com.miroit.sicksu.meal.domain.dto.request.EmployeeInfoRequestDto;
import com.miroit.sicksu.meal.domain.dto.request.MealUseRequestDto;
import com.miroit.sicksu.meal.domain.dto.response.EmployeeInfoResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.MealUseResponseDto;
import com.miroit.sicksu.meal.service.MealDeviceService;
import com.miroit.sicksu.meal.service.MealDeviceServiceTx;
import com.miroit.sicksu.serial.SerialRun;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MealDeviceController {
    private final MealDeviceService mealDeviceService;
    private final MealDeviceServiceTx mealDeviceServiceTx;
    private final SerialRun serialRun;

    @GetMapping(value={"/"})
    public String index(Model model) {
        Map result = this.mealDeviceService.mainInfo();
        model.addAttribute("mainInfo", (Object)result);
        return "main";
    }

    @ResponseBody
    @PostMapping(value={"/auth-check"})
    public String adminPwdCheck(@RequestParam String adminPwd) {
        return this.mealDeviceService.adminPwdCheck(adminPwd);
    }

    @ResponseBody
    @PostMapping(value={"/device-save"})
    public String saveDeviceId(@RequestParam Integer deviceId) {
        return this.mealDeviceServiceTx.saveDeviceId(deviceId);
    }

    @ResponseBody
    @GetMapping(value={"/time-check"})
    public String mealTime() {
        return this.mealDeviceService.isMealTime();
    }

    @GetMapping(value={"/employee-input"})
    public String employeeIdInput(Model model, @RequestParam(required=false) String taggingType, @RequestParam(required=false) String taggingEeid, @RequestParam(required=false) String screenType) {
        model.addAttribute("taggingType", (Object)taggingType);
        model.addAttribute("taggingEeid", (Object)taggingEeid);
        return screenType;
    }

    @ResponseBody
    @PostMapping(value={"/employee-info"})
    public EmployeeInfoResponseDto employeeInfo(@RequestBody EmployeeInfoRequestDto requestDto) {
        return this.mealDeviceService.employeeInfo(requestDto);
    }

    @ResponseBody
    @PostMapping(value={"/meal-use"})
    public MealUseResponseDto mealUse(@RequestBody MealUseRequestDto requestDto) {
        return this.mealDeviceService.mealUse(requestDto);
    }

    @ResponseBody
    @GetMapping(value={"/serial-status"})
    public boolean getStatus() {
        return this.serialRun.getIsConnected();
    }

    @Generated
    public MealDeviceController(MealDeviceService mealDeviceService, MealDeviceServiceTx mealDeviceServiceTx, SerialRun serialRun) {
        this.mealDeviceService = mealDeviceService;
        this.mealDeviceServiceTx = mealDeviceServiceTx;
        this.serialRun = serialRun;
    }
}

