/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.meal.domain.entity;

import com.miroit.sicksu.meal.domain.dto.response.MealTimeResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.MealUseResponseDto;
import com.miroit.sicksu.meal.domain.entity.MealTime;
import com.miroit.sicksu.utils.enums.MealType;
import com.miroit.sicksu.utils.util.TimeUtil;
import io.micrometer.common.util.StringUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import lombok.Generated;
import org.hibernate.annotations.ColumnDefault;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/*
 * Exception performing whole class analysis ignored.
 */
@EntityListeners(value={AuditingEntityListener.class})
@Entity
@Table(name="TB_MEAL_TIME")
public class MealTime {
    @Id
    private Integer readerNo;
    private String readerName;
    private String cafeName;
    private String bfBeginTime;
    private String bfEndTime;
    private String lunBeginTime;
    private String lunEndTime;
    private String dinBeginTime;
    private String dinEndTime;
    private String ngtBeginTime;
    private String ngtEndTime;
    @ColumnDefault(value="0")
    private Integer readerCount = 0;
    @ColumnDefault(value="0")
    private Integer readerCountA = 0;
    @ColumnDefault(value="0")
    private Integer readerCountB = 0;
    @ColumnDefault(value="0")
    private Integer readerCountC = 0;
    @ColumnDefault(value="0")
    private Integer readerCountD = 0;
    @CreatedDate
    private LocalDateTime createdDt;
    @LastModifiedDate
    private LocalDateTime updateDt;

    public static MealTime toEntity(MealTimeResponseDto dto) {
        return MealTime.builder().readerNo(dto.getReaderNo()).readerName(dto.getReaderName()).cafeName(dto.getCafeName()).bfBeginTime(dto.getBfBeginTime()).bfEndTime(dto.getBfEndTime()).lunBeginTime(dto.getLunBeginTime()).lunEndTime(dto.getLunEndTime()).dinBeginTime(dto.getDinBeginTime()).dinEndTime(dto.getDinEndTime()).ngtBeginTime(dto.getNgtBeginTime()).ngtEndTime(dto.getNgtEndTime()).readerCount(Integer.valueOf(0)).build();
    }

    public boolean isMealTime() {
        return this.isMealTimeValid(this.bfBeginTime, this.bfEndTime) || this.isMealTimeValid(this.lunBeginTime, this.lunEndTime) || this.isMealTimeValid(this.dinBeginTime, this.dinEndTime) || this.isMealTimeValid(this.ngtBeginTime, this.ngtEndTime);
    }

    private boolean isMealTimeValid(String begin, String end) {
        if (StringUtils.isBlank((String)begin) || StringUtils.isBlank((String)end)) {
            return false;
        }
        try {
            LocalTime now = LocalTime.now();
            LocalTime beginTime = TimeUtil.getTimeFromString((String)begin);
            LocalTime endTime = TimeUtil.getTimeFromString((String)end);
            return TimeUtil.isBetweenTime((LocalTime)beginTime, (LocalTime)endTime, (LocalTime)now);
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    public MealType getMealTimeName() {
        if (this.isMealTimeValid(this.bfBeginTime, this.bfEndTime)) {
            return MealType.BREAKFAST;
        }
        if (this.isMealTimeValid(this.lunBeginTime, this.lunEndTime)) {
            return MealType.LUNCH;
        }
        if (this.isMealTimeValid(this.dinBeginTime, this.dinEndTime)) {
            return MealType.DINNER;
        }
        if (this.isMealTimeValid(this.ngtBeginTime, this.ngtEndTime)) {
            return MealType.LATE_NIGHT_SNACK;
        }
        return MealType.PREPARING;
    }

    public void setReaderCount(MealUseResponseDto result) {
        MealType mealType = this.getMealTimeName();
        switch (1.$SwitchMap$com$miroit$sicksu$utils$enums$MealType[mealType.ordinal()]) {
            case 1: {
                this.readerCount = result.getReaderCountA();
                break;
            }
            case 2: {
                this.readerCount = result.getReaderCountB();
                break;
            }
            case 3: {
                this.readerCount = result.getReaderCountC();
                break;
            }
            case 4: {
                this.readerCount = result.getReaderCountD();
            }
        }
    }

    public Integer getNowReaderCount() {
        MealType mealType = this.getMealTimeName();
        return switch (1.$SwitchMap$com$miroit$sicksu$utils$enums$MealType[mealType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.readerCountA;
            case 2 -> this.readerCountB;
            case 3 -> this.readerCountC;
            case 4 -> this.readerCountD;
            case 5 -> this.readerCount;
        };
    }

    @Generated
    public static MealTimeBuilder builder() {
        return new MealTimeBuilder();
    }

    @Generated
    private MealTime(Integer readerNo, String readerName, String cafeName, String bfBeginTime, String bfEndTime, String lunBeginTime, String lunEndTime, String dinBeginTime, String dinEndTime, String ngtBeginTime, String ngtEndTime, Integer readerCount, Integer readerCountA, Integer readerCountB, Integer readerCountC, Integer readerCountD, LocalDateTime createdDt, LocalDateTime updateDt) {
        this.readerNo = readerNo;
        this.readerName = readerName;
        this.cafeName = cafeName;
        this.bfBeginTime = bfBeginTime;
        this.bfEndTime = bfEndTime;
        this.lunBeginTime = lunBeginTime;
        this.lunEndTime = lunEndTime;
        this.dinBeginTime = dinBeginTime;
        this.dinEndTime = dinEndTime;
        this.ngtBeginTime = ngtBeginTime;
        this.ngtEndTime = ngtEndTime;
        this.readerCount = readerCount;
        this.readerCountA = readerCountA;
        this.readerCountB = readerCountB;
        this.readerCountC = readerCountC;
        this.readerCountD = readerCountD;
        this.createdDt = createdDt;
        this.updateDt = updateDt;
    }

    @Generated
    protected MealTime() {
    }

    @Generated
    public Integer getReaderNo() {
        return this.readerNo;
    }

    @Generated
    public String getReaderName() {
        return this.readerName;
    }

    @Generated
    public String getCafeName() {
        return this.cafeName;
    }

    @Generated
    public String getBfBeginTime() {
        return this.bfBeginTime;
    }

    @Generated
    public String getBfEndTime() {
        return this.bfEndTime;
    }

    @Generated
    public String getLunBeginTime() {
        return this.lunBeginTime;
    }

    @Generated
    public String getLunEndTime() {
        return this.lunEndTime;
    }

    @Generated
    public String getDinBeginTime() {
        return this.dinBeginTime;
    }

    @Generated
    public String getDinEndTime() {
        return this.dinEndTime;
    }

    @Generated
    public String getNgtBeginTime() {
        return this.ngtBeginTime;
    }

    @Generated
    public String getNgtEndTime() {
        return this.ngtEndTime;
    }

    @Generated
    public Integer getReaderCount() {
        return this.readerCount;
    }

    @Generated
    public Integer getReaderCountA() {
        return this.readerCountA;
    }

    @Generated
    public Integer getReaderCountB() {
        return this.readerCountB;
    }

    @Generated
    public Integer getReaderCountC() {
        return this.readerCountC;
    }

    @Generated
    public Integer getReaderCountD() {
        return this.readerCountD;
    }

    @Generated
    public LocalDateTime getCreatedDt() {
        return this.createdDt;
    }

    @Generated
    public LocalDateTime getUpdateDt() {
        return this.updateDt;
    }
}

