/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.meal.service;

import com.miroit.sicksu.external.mealmng.MealMngService;
import com.miroit.sicksu.external.sitecube.SiteCubeService;
import com.miroit.sicksu.external.sitecube.dto.SiteCubeResponseDto;
import com.miroit.sicksu.meal.domain.dto.request.EmployeeInfoRequestDto;
import com.miroit.sicksu.meal.domain.dto.request.MealUseRequestDto;
import com.miroit.sicksu.meal.domain.dto.response.EmployeeInfoResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.MealUseResponseDto;
import com.miroit.sicksu.meal.domain.entity.MealTime;
import com.miroit.sicksu.meal.repository.MealTimeRepository;
import com.miroit.sicksu.meal.service.MealDeviceServiceTx;
import com.miroit.sicksu.serial.WarningLight;
import com.miroit.sicksu.utils.enums.StatusType;
import com.miroit.sicksu.utils.util.TimeUtil;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class MealDeviceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MealDeviceService.class);
    private final MealMngService mealMngService;
    private final SiteCubeService siteCubeService;
    private final MealTimeRepository mealTimeRepository;
    private final SimpMessagingTemplate messagingTemplate;
    @Value(value="${admin-pwd}")
    private String adminPwd;
    @Value(value="${meal.url}")
    private String mealUrl;
    @Value(value="${site-cube.url}")
    private String siteCubeUrl;
    private final MealDeviceServiceTx mealDeviceServiceTx;

    private MealTime mealTimeInfo() {
        MealTime entity = this.mealTimeRepository.findTopByOrderByUpdateDtDesc();
        return !ObjectUtils.isEmpty((Object)entity) ? entity : null;
    }

    public Map<String, Object> mainInfo() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MealTime entity = this.mealTimeInfo();
        result.put("readerCount", entity != null ? entity.getReaderCount() : 0);
        result.put("mealType", entity != null ? entity.getMealTimeName().getMealTypeName() : "\uc900\ube44\uc911");
        result.put("readerNo", entity != null ? entity.getReaderNo() : null);
        result.put("cafeName", entity != null ? entity.getReaderName() : "");
        result.put("nowDate", TimeUtil.getNowDateToString());
        log.info("readerNo: {}", result.get("readerNo"));
        return result;
    }

    public String adminPwdCheck(String adminPwd) {
        return adminPwd.equals(this.adminPwd) ? StatusType.OK.name() : StatusType.NO.name();
    }

    public String isMealTime() {
        MealTime entity = this.mealTimeInfo();
        return entity != null && entity.isMealTime() ? StatusType.OK.name() : StatusType.NO.name();
    }

    public EmployeeInfoResponseDto employeeInfo(EmployeeInfoRequestDto requestDto) {
        try {
            EmployeeInfoResponseDto result = this.mealMngService.employeeInfo(requestDto);
            if (result.getEeid() == null) {
                result.setStatus(StatusType.NO.name());
            } else {
                result.setStatus(StatusType.OK.name());
                if (result.getNameKor().length() == 3) {
                    result.setNameKor(result.getNameKor().substring(0, 2) + "*");
                } else if (result.getNameKor().length() == 2) {
                    result.setNameKor(result.getNameKor().substring(0, 1) + "*");
                }
                result.setEeid(result.getEeid().substring(0, 5) + "**");
            }
            result.setType(requestDto.getType());
            return result;
        }
        catch (Exception e) {
            log.error("\uc9c1\uc6d0 \uc815\ubcf4 \uc870\ud68c\uc911 \uc5d0\ub7ec\ubc1c\uc0dd : {}", (Object)e.getMessage());
            return EmployeeInfoResponseDto.builder().type(requestDto.getType()).status(StatusType.OFFLINE.name()).build();
        }
    }

    public void employeeTagging(String taggingData) {
        String sabun = this.siteCubeCallForSabun(taggingData);
        log.info("\uc2dd\uc218 \uc0ac\uc6a9\ucc98\ub9ac\ud560 \uc0ac\uc6d0\ubc88\ud638: {}", (Object)sabun);
        Object url = this.mealTimeInfo() == null ? "/" : "/employee-input?taggingType=T&taggingEeid=" + sabun;
        this.messagingTemplate.convertAndSend((Object)"/sub/tagging", url);
    }

    private String siteCubeCallForSabun(String taggingData) {
        SiteCubeResponseDto result = null;
        try {
            result = this.siteCubeService.siteCubeInfo(taggingData);
        }
        catch (Exception e) {
            log.error("\uc0ac\uc774\ud2b8\ud050\ube0c \uc870\ud68c\uc911 \uc5d0\ub7ec\ubc1c\uc0dd : {}", (Object)e.getMessage());
            log.error("API Error : {}", (Object)("API URL : " + this.siteCubeUrl + "\nParameter : taggingData"));
        }
        if (result == null || result.getCard() == null || result.getCard().getUserId() == null) {
            log.warn("\uc0ac\uc774\ud2b8\ud050\ube0c \uc0ac\ubc88 \uc870\ud68c \uc2e4\ud328 - \ud0dc\uae45\ub370\uc774\ud130: {}", (Object)taggingData);
            return taggingData.substring(0, 7);
        }
        log.warn("\uc0ac\uc774\ud2b8\ud050\ube0c \uc0ac\ubc88 \uc870\ud68c \uc131\uacf5");
        return result.getCard().getUserId();
    }

    public MealUseResponseDto mealUse(MealUseRequestDto requestDto) {
        WarningLight warninglight = new WarningLight();
        MealTime entity = this.mealTimeInfo();
        if (entity == null) {
            return MealUseResponseDto.builder().status(Integer.valueOf(9)).build();
        }
        requestDto.setReaderNo(entity.getReaderNo());
        try {
            log.info("\uc2dd\uc218 \uc0ac\uc6a9 \ucc98\ub9ac\ud560 requestDto: {}", (Object)requestDto);
            MealUseResponseDto result = this.mealMngService.mealUse(requestDto);
            if (result.getStatus() != null) {
                log.info("\uc2dd\uc218 \uc0ac\uc6a9 \ucc98\ub9ac\uacb0\uacfc \uc0c1\ud0dc: {}", (Object)result.getStatus());
                this.mealDeviceServiceTx.setReaderCount(entity.getReaderNo(), result);
                this.setMesssageEng(result);
                warninglight.setLight(result.getStatus().intValue(), 1);
            }
            return result;
        }
        catch (Exception e) {
            log.error("\uc2dd\uc218 \uc0ac\uc6a9\ucc98\ub9ac\uc911 \uc5d0\ub7ec\ubc1c\uc0dd : {}", (Object)e.getMessage());
            log.error("Error API : {}", (Object)("API URL : " + this.mealUrl + "/use\nParameter : " + String.valueOf(requestDto)));
            warninglight.setLight(1, 1);
            try {
                this.mealDeviceServiceTx.saveOfflineData(requestDto);
            }
            catch (Exception ex) {
                log.error("\uc624\ud504\ub77c\uc778 \ub370\uc774\ud130 \uc800\uc7a5 \uc2e4\ud328", (Throwable)ex);
            }
            return MealUseResponseDto.builder().status(Integer.valueOf(1)).message("\ud1b5\uc2e0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.").messageEng("Network error occurred.").build();
        }
    }

    private void setMesssageEng(MealUseResponseDto result) {
        if (result.getStatus() == 1) {
            switch (result.getMessage()) {
                case "PAYCO \uc0ac\uc6a9 \ud6c4 3\uc2dc\uac04\uc774\ub0b4 \ucde8\uc2dd\ubd88\uac00": {
                    result.setMessageEng("Not available within 3hours of PAYCO usage");
                    break;
                }
                case "\ub4f1\ub85d\ub41c ID\uc544\ub2d8": {
                    result.setMessageEng("Non-identifying ID");
                    break;
                }
                case "\ucde8\uc2dd\ubd88\uac00": {
                    result.setMessageEng("Not available");
                    break;
                }
                case "KEYIN\ubd88\uac00": {
                    result.setMessageEng("Manual input not available");
                    break;
                }
                case "ID TAGGING\ubd88\uac00": {
                    result.setMessageEng("ID Tagging not available");
                    break;
                }
                case "OK": {
                    result.setMessageEng("OK");
                    break;
                }
                case "~\ubd84 \ub4a4 \uc0ac\uc6a9\uac00\ub2a5": {
                    result.setMessageEng("Available after ~ minutes");
                    break;
                }
                case "\uac19\uc740\ub07c\ub2c8\ubd88\uac00": {
                    result.setMessageEng("Not available at the same meal time");
                    break;
                }
                case "\uc911\ubcf5\uc0ac\uc6a9": {
                    result.setMessageEng("No duplicate use allowed");
                    break;
                }
                case "\ucde8\uc2dd\ubd88\uac00\uc9c0\uc5ed": {
                    result.setMessageEng("Not avaibale area to use");
                    break;
                }
                case "\uc57c\uc2dd\uc774\uc6a9\ubd88\uac00": {
                    result.setMessageEng("Not available for late-night meal");
                    break;
                }
                case "\uc0ac\uc6a9\ub07c\ub2c8\ucd08\uacfc": {
                    result.setMessageEng("Meal usage exceeded");
                    break;
                }
                case "MAX \uc77c3\uc2dd": {
                    result.setMessageEng("Maximum daily limit(3) exceeded");
                    break;
                }
                case "\uc77c\uc81c\ud55c\ucd08\uacfc": {
                    result.setMessageEng("Daily meal limitation exceeded");
                    break;
                }
                case "\uc77c\uc0ac\uc6a9\ucd08\uacfc": {
                    result.setMessageEng("Daily meal usage exceeded");
                    break;
                }
                case "\uc6d4\uc81c\ud55c\ucd08\uacfc": {
                    result.setMessageEng("Monthly meal usage exceeded");
                    break;
                }
                case "\uc870\uc2dd\uc774\uc6a9\ubd88\uac00": {
                    result.setMessageEng("Not available for breakfast");
                    break;
                }
                case "\uc911\uc2dd\uc774\uc6a9\ubd88\uac00": {
                    result.setMessageEng("Not available for lunch");
                    break;
                }
                case "\uc11d\uc2dd\uc774\uc6a9\ubd88\uac00": {
                    result.setMessageEng("Not available for dinner");
                    break;
                }
                case "\ucde8\uc2dd\uc2dc\uac04\uc544\ub2d8": {
                    result.setMessageEng("It is not meal service hours");
                    break;
                }
                case "\ucde8\uc2dd\ubd88\uac00\uc2dc\uac04": {
                    result.setMessageEng("It is not meal service hours");
                    break;
                }
                case "\ud734\ubb34\uc77c \uc785\ub825\ubd88\uac00": {
                    result.setMessageEng("Not available on non-working day");
                    break;
                }
                case "\ud734\ubb34\uc77c \uc0ac\uc6a9\ucd08\uacfc": {
                    result.setMessageEng("Not available on non-working day");
                    break;
                }
                case "\ud734\ubb34\uc77c \uc0ac\uc6a9\ubd88\uac00": {
                    result.setMessageEng("Not available on non-working day");
                }
            }
        }
    }

    @Generated
    public MealDeviceService(MealMngService mealMngService, SiteCubeService siteCubeService, MealTimeRepository mealTimeRepository, SimpMessagingTemplate messagingTemplate, MealDeviceServiceTx mealDeviceServiceTx) {
        this.mealMngService = mealMngService;
        this.siteCubeService = siteCubeService;
        this.mealTimeRepository = mealTimeRepository;
        this.messagingTemplate = messagingTemplate;
        this.mealDeviceServiceTx = mealDeviceServiceTx;
    }
}

