/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.meal.service;

import com.miroit.sicksu.external.mealmng.MealMngService;
import com.miroit.sicksu.meal.domain.dto.request.MealUseRequestDto;
import com.miroit.sicksu.meal.domain.dto.response.MealTimeResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.MealUseOfflineResponseDto;
import com.miroit.sicksu.meal.domain.dto.response.MealUseResponseDto;
import com.miroit.sicksu.meal.domain.entity.MealTime;
import com.miroit.sicksu.meal.domain.entity.MealUseOffline;
import com.miroit.sicksu.meal.repository.MealTimeRepository;
import com.miroit.sicksu.meal.repository.MealUseOfflineRepository;
import com.miroit.sicksu.utils.enums.StatusType;
import com.miroit.sicksu.utils.util.TimeUtil;
import jakarta.transaction.Transactional;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class MealDeviceServiceTx {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MealDeviceServiceTx.class);
    private final MealMngService mealMngService;
    private final MealTimeRepository mealTimeRepository;
    private final MealUseOfflineRepository mealUseOfflineRepository;

    @Transactional
    public String saveDeviceId(Integer readerNo) {
        String status;
        try {
            MealTimeResponseDto dto = this.mealMngService.mealTime(readerNo);
            if (!ObjectUtils.isEmpty((Object)dto)) {
                status = StatusType.OK.name();
                this.mealTimeRepository.save((Object)MealTime.toEntity((MealTimeResponseDto)dto));
            } else {
                status = StatusType.NO.name();
            }
        }
        catch (Exception e) {
            log.error("\uc5d0\ub7ec \ubc1c\uc0dd");
            status = StatusType.ERROR.name();
        }
        return status;
    }

    @Transactional
    public void setReaderCount(Integer readerNo, MealUseResponseDto result) {
        MealTime entity = (MealTime)this.mealTimeRepository.findById((Object)readerNo).orElseThrow();
        entity.setReaderCount(result);
    }

    @Transactional
    public void saveOfflineData(MealUseRequestDto requestDto) {
        this.mealUseOfflineRepository.save((Object)requestDto.toMealUseOfflineEntity());
    }

    @Transactional
    public int mealUseOffline() {
        String todayStart = TimeUtil.getStringFromDateTime((LocalDateTime)LocalDate.now().atStartOfDay());
        String todayEnd = TimeUtil.getStringFromDateTime((LocalDateTime)LocalDate.now().atTime(LocalTime.MAX));
        List offlineData = this.mealUseOfflineRepository.findByUseTimeBetween(todayStart, todayEnd);
        log.info("===== \ud574\ub2f9 \ub0a0\uc9dc\uc758 \ub370\uc774\ud130 [\uc870\ud68c] \uc2dc\uc791 =====");
        log.info("todayStart: {}, todayEnd: {}, offlineData: {}", new Object[]{todayStart, todayEnd, offlineData.size()});
        if (ObjectUtils.isEmpty((Object)offlineData)) {
            return 0;
        }
        List<MealUseRequestDto> dtoList = offlineData.stream().map(MealUseOffline::toMealUseRequestDto).toList();
        MealUseOfflineResponseDto sendResult = this.mealMngService.mealUseOffline(dtoList);
        log.info("===== \ud574\ub2f9 \ub0a0\uc9dc\uc758 \ub370\uc774\ud130 [\uc804\uc1a1] \uc2dc\uc791 =====");
        log.info("\uc804\uc1a1 \uacb0\uacfc: {}", (Object)sendResult);
        log.info("\uc804\uc1a1 \uc644\ub8cc\ub41c \ub370\uc774\ud130: {}", (Object)sendResult.getResultList().size());
        offlineData.forEach(MealUseOffline::setUseYn);
        return sendResult.getResultList().size();
    }

    @Generated
    public MealDeviceServiceTx(MealMngService mealMngService, MealTimeRepository mealTimeRepository, MealUseOfflineRepository mealUseOfflineRepository) {
        this.mealMngService = mealMngService;
        this.mealTimeRepository = mealTimeRepository;
        this.mealUseOfflineRepository = mealUseOfflineRepository;
    }
}

