/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.miroit.sicksu.meal.service.MealDeviceService;
import com.miroit.sicksu.serial.WarningLight;
import com.miroit.sicksu.utils.config.DeviceToggleProperties;
import com.miroit.sicksu.utils.util.BatRunner;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SerialRun {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerialRun.class);
    private volatile SerialPort serialPort;
    private final MealDeviceService mealDeviceService;
    private final DeviceToggleProperties props;
    private volatile boolean isConnected = false;
    private final AtomicBoolean resetting = new AtomicBoolean(false);
    private final AtomicBoolean reading = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ExecutorService tagExecutor = Executors.newSingleThreadExecutor();
    private final BatRunner batRunner = new BatRunner();

    public SerialRun(MealDeviceService mealDeviceService, DeviceToggleProperties props) {
        this.mealDeviceService = mealDeviceService;
        this.props = props;
    }

    public void trigger(String taggingData) {
        this.tagExecutor.submit(() -> {
            try {
                this.mealDeviceService.employeeTagging(taggingData);
            }
            catch (Exception e) {
                log.error("employeeTagging \ucc98\ub9ac \uc911 \uc624\ub958(tag={})", (Object)taggingData, (Object)e);
            }
        });
    }

    @Scheduled(fixedDelay=3000L)
    public void portConnection() {
        try {
            if (this.serialPort == null || !this.serialPort.isOpen()) {
                this.isConnected = false;
                WarningLight warninglight = new WarningLight();
                warninglight.setLight(1, 3);
                this.read();
            } else {
                this.isConnected = true;
            }
        }
        catch (Exception e) {
            log.error("portConnection \uc2a4\ucf00\uc904\ub7ec \uc624\ub958", (Throwable)e);
        }
    }

    private void resetDeviceAndReconnectOnce() {
        if (!this.resetting.compareAndSet(false, true)) {
            return;
        }
        this.executor.submit(() -> {
            try {
                this.safeClosePort();
                BatRunner.Result r = this.batRunner.runToggleBatByEnv(this.props.getBatPath(), this.props.getInstanceId(), this.props.getToggleDelayMs());
                if (r.exitCode != 0) {
                    log.error("BAT \uc2e4\ud328(exitCode={}): {}", (Object)r.exitCode, (Object)r.output);
                    return;
                }
                log.info("BAT \uc131\uacf5: {}", (Object)r.output);
                this.read();
            }
            catch (Exception e) {
                log.error("BAT \uc2e4\ud589/\uc7ac\uc5f0\uacb0 \uc911 \uc624\ub958", (Throwable)e);
            }
            finally {
                this.resetting.set(false);
            }
        });
    }

    private void safeClosePort() {
        block6: {
            try {
                if (this.serialPort == null) break block6;
                try {
                    if (this.serialPort.isOpen()) {
                        this.serialPort.closePort();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.serialPort = null;
                this.reading.set(false);
            }
        }
    }

    public boolean getIsConnected() {
        return this.isConnected;
    }

    public void read() {
        if (!this.reading.compareAndSet(false, true)) {
            return;
        }
        try {
            SerialPort[] ports;
            String foundPortName = null;
            for (SerialPort port : ports = SerialPort.getCommPorts()) {
                if (port.getPortDescription() == null || !port.getPortDescription().contains("USB <-> Serial Converter")) continue;
                foundPortName = port.getSystemPortName();
                break;
            }
            if (foundPortName == null) {
                log.error("\uc5f0\uacb0\ud560 \uc218 \uc788\ub294 \ub9ac\ub354\uae30\ub97c \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.");
                this.reading.set(false);
                return;
            }
            this.safeClosePort();
            this.serialPort = SerialPort.getCommPort(foundPortName);
            this.serialPort.setBaudRate(19200);
            this.serialPort.setNumDataBits(8);
            this.serialPort.setParity(0);
            this.serialPort.setNumStopBits(1);
            this.serialPort.setComPortTimeouts(1, 100, 0);
            if (!this.serialPort.openPort()) {
                log.error("\uce74\ub4dc\ub9ac\ub354\uae30 \ud3ec\ud2b8 open \uc2e4\ud328: {}", (Object)foundPortName);
                this.reading.set(false);
                return;
            }
            log.info("\uce74\ub4dc\ub9ac\ub354\uae30 \uc5f0\uacb0 \uc131\uacf5: {}", (Object)foundPortName);
            this.isConnected = true;
            Thread readThread = new Thread(() -> {
                try (ByteArrayOutputStream packetBuffer = new ByteArrayOutputStream();){
                    byte[] buffer = new byte[1024];
                    while (this.serialPort != null && this.serialPort.isOpen()) {
                        int numRead = this.serialPort.readBytes(buffer, (long)buffer.length);
                        if (numRead > 0) {
                            packetBuffer.write(buffer, 0, numRead);
                        } else {
                            if (numRead == 0) {
                                packetBuffer.reset();
                                continue;
                            }
                            log.warn("readBytes \ubc18\ud658\uac12\uc774 \uc74c\uc218\uc785\ub2c8\ub2e4(numRead={})", (Object)numRead);
                            packetBuffer.reset();
                            continue;
                        }
                        while (packetBuffer.size() >= 8) {
                            byte[] fullPacket = packetBuffer.toByteArray();
                            byte[] tagBytes = Arrays.copyOfRange(fullPacket, 0, 8);
                            StringBuilder hexStr = new StringBuilder();
                            for (byte b : tagBytes) {
                                hexStr.append(String.format("%02X", b));
                            }
                            log.info("\uc218\uc2e0\ub41c \ud0dc\uadf8 HEX: {}", (Object)hexStr);
                            byte[] remaining = Arrays.copyOfRange(fullPacket, 8, fullPacket.length);
                            packetBuffer.reset();
                            packetBuffer.write(remaining, 0, remaining.length);
                            this.trigger(hexStr.toString());
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\ud1b5\uc2e0 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd", (Throwable)e);
                }
                finally {
                    log.error("\ub9ac\ub354\uae30 \uc2a4\ub808\ub4dc \uc885\ub8cc");
                    this.isConnected = false;
                    this.reading.set(false);
                    this.safeClosePort();
                }
            }, "SerialReader");
            readThread.setDaemon(true);
            readThread.start();
        }
        catch (Exception e) {
            this.reading.set(false);
            log.error("read() \uc2e4\ud589 \uc911 \uc624\ub958", (Throwable)e);
        }
    }
}

