/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.serial;

import com.fazecast.jSerialComm.SerialPort;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarningLight {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarningLight.class);
    private String PORT_NAME = "COM3";
    private static final int BAUD_RATE = 9600;
    private static final byte CMD_ALL_OFF = 0;
    private static final byte CMD_CH1_ON = 17;
    private static final byte CMD_CH2_ON = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLight(int success, int seconds) {
        log.info("setLight({}, {})", (Object)success, (Object)seconds);
        try {
            SerialPort[] ports = SerialPort.getCommPorts();
            log.info("\uc2dc\uc2a4\ud15c\uc5d0 \uc5f0\uacb0\ub41c \uc2dc\ub9ac\uc5bc \ud3ec\ud2b8 \ubaa9\ub85d:");
            for (SerialPort port : ports) {
                log.info("- \ud3ec\ud2b8 \uc774\ub984: {}", (Object)port.getSystemPortName());
                log.info("  \uc124\uba85: {}", (Object)port.getDescriptivePortName());
                log.info("  \ud3ec\ud2b8 ID: {}", (Object)port.getPortDescription());
                log.info("");
                if (!port.getPortDescription().contains("USB-Serial Controller")) continue;
                this.PORT_NAME = port.getSystemPortName();
            }
            SerialPort port = SerialPort.getCommPort((String)this.PORT_NAME);
            port.setBaudRate(9600);
            port.setNumDataBits(8);
            port.setNumStopBits(1);
            port.setParity(0);
            int seconds_set = seconds * 1000;
            if (!port.openPort()) {
                throw new RuntimeException("\uc2dc\ub9ac\uc5bc \ud3ec\ud2b8\ub97c \uc5f4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + this.PORT_NAME);
            }
            try {
                this.sendCommand(port, (byte)0);
                Thread.sleep(100L);
                if (success == 0) {
                    this.sendCommand(port, (byte)17);
                } else {
                    this.sendCommand(port, (byte)2);
                }
                Thread.sleep(seconds_set);
                this.sendCommand(port, (byte)0);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (port.isOpen()) {
                    port.closePort();
                }
            }
        }
        catch (Throwable t) {
            log.error("\uacbd\uad11\ub4f1 \uc5d0\ub7ec \ubc1c\uc0dd");
        }
    }

    private void sendCommand(SerialPort port, byte cmd) {
        port.writeBytes(new byte[]{cmd}, 1L);
    }
}

