/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.utils.component;

import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class BrowserLauncher
implements ApplicationListener<WebServerInitializedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrowserLauncher.class);

    public void onApplicationEvent(WebServerInitializedEvent event) {
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            int port = event.getWebServer().getPort();
            String url = "http://localhost:" + port;
            try {
                String chromeExe = this.findFirstExisting(new String[]{"C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe", "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe"});
                if (chromeExe != null) {
                    Path profileDir = Path.of(System.getProperty("user.home"), ".sicksu-kiosk-chrome");
                    Files.createDirectories(profileDir, new FileAttribute[0]);
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add(chromeExe);
                    cmd.add("--new-window");
                    cmd.add("--kiosk");
                    cmd.add("--no-first-run");
                    cmd.add("--autoplay-policy=no-user-gesture-required");
                    cmd.add("--user-data-dir=" + String.valueOf(profileDir.toAbsolutePath()));
                    cmd.add(url);
                    new ProcessBuilder(cmd).start();
                    log.info("Chrome \uc2e4\ud589(autoplay \uc6b0\ud68c \ud50c\ub798\uadf8 \ud3ec\ud568): {}", cmd);
                    return;
                }
                this.openWithDesktop(url);
            }
            catch (Exception e) {
                log.error("\ube0c\ub77c\uc6b0\uc800 \uc2e4\ud589 \uc2e4\ud328", (Throwable)e);
                try {
                    this.openWithDesktop(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void openWithDesktop(String url) throws Exception {
        URI uri = new URI(url);
        if (Desktop.isDesktopSupported() && !GraphicsEnvironment.isHeadless()) {
            Desktop.getDesktop().browse(uri);
            log.info("\uae30\ubcf8 \ube0c\ub77c\uc6b0\uc800\ub85c \uc2e4\ud589: {}", (Object)uri);
        } else {
            log.warn("\ube0c\ub77c\uc6b0\uc800 \uc790\ub3d9\uc5f4\uae30\ub97c \uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud658\uacbd\uc785\ub2c8\ub2e4.");
        }
    }

    private String findFirstExisting(String ... paths) {
        for (String p : paths) {
            if (!new File(p).exists()) continue;
            return p;
        }
        return null;
    }
}

