/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.utils.component;

import com.miroit.sicksu.utils.component.WebClientComponent;
import com.miroit.sicksu.utils.enums.RequestType;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Component
public class WebClientComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebClientComponent.class);
    private final WebClient secureWebClient;
    private final WebClient insecureWebClient;
    @Value(value="${workday.id}")
    private String workdayId;
    @Value(value="${workday.pw}")
    private String workdayPw;

    public <T, R> R post(String uri, String token, T requestBody, Class<R> responseType) {
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.secureWebClient.post().uri(uri, new Object[0])).header("Authorization", new String[]{token})).bodyValue(requestBody).retrieve();
        return (R)this.executeRequest(responseSpec, responseType);
    }

    public <R> R get(RequestType type, String uri, String token, Map<String, String> queryParams, Class<R> responseType) {
        WebClient webClient = RequestType.SITE_CUBE.equals((Object)type) ? this.insecureWebClient : this.secureWebClient;
        WebClient.RequestHeadersSpec request = webClient.get().uri(builder -> {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)uri);
            if (queryParams != null) {
                queryParams.forEach((arg_0, arg_1) -> WebClientComponent.lambda$get$0((UriBuilder)uriBuilder, arg_0, arg_1));
            }
            return uriBuilder.build(new Object[0]);
        });
        switch (1.$SwitchMap$com$miroit$sicksu$utils$enums$RequestType[type.ordinal()]) {
            case 1: {
                request.header("Authorization", new String[]{token}).header("Authorization_workday", new String[]{this.buildAuthorizationHeader(this.workdayId, this.workdayPw)});
                break;
            }
            case 2: {
                request.header("login_token", new String[]{token});
            }
        }
        WebClient.ResponseSpec responseSpec = request.retrieve();
        return (R)this.executeRequest(responseSpec, responseType);
    }

    private <R> R executeRequest(WebClient.ResponseSpec responseSpec, Class<R> responseType) {
        try {
            return (R)responseSpec.onStatus(HttpStatusCode::isError, response -> response.bodyToMono(String.class).doOnNext(error -> log.error("WebClient \uc624\ub958 \uc751\ub2f5: {}", error)).then(Mono.error((Throwable)new RuntimeException("API \uc694\uccad \uc2e4\ud328")))).bodyToMono(responseType).timeout(Duration.ofSeconds(3L)).block();
        }
        catch (WebClientResponseException e) {
            log.error("WebClient \uc751\ub2f5 \uc624\ub958: status={}, body={}, message={}", new Object[]{e.getStatusCode().value(), e.getResponseBodyAsString(), e.getMessage()});
            throw new RuntimeException("API \ud638\ucd9c \uc2e4\ud328", e);
        }
        catch (Exception e) {
            log.error("API \ud638\ucd9c \uc911 \uc608\uc678 \ubc1c\uc0dd: {} - {}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            throw new RuntimeException("API \ud638\ucd9c \uc911 \uc608\uc678 \ubc1c\uc0dd", e);
        }
    }

    private String buildAuthorizationHeader(String workdayId, String workdayPw) {
        String credentials = workdayId + ":" + workdayPw;
        String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        return "Basic " + encoded;
    }

    @Generated
    public WebClientComponent(WebClient secureWebClient, WebClient insecureWebClient) {
        this.secureWebClient = secureWebClient;
        this.insecureWebClient = insecureWebClient;
    }

    private static /* synthetic */ void lambda$get$0(UriBuilder rec$, String x$0, Object xva$1) {
        rec$.queryParam(x$0, new Object[]{xva$1});
    }
}

