/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.utils.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataSourceConfig {
    @Bean
    public DataSource dataSource() {
        String userHome = System.getProperty("user.home");
        Path dbPath = Paths.get(userHome, "sicksu", "db", "sicksu.db");
        File dbDir = dbPath.getParent().toFile();
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:sqlite:" + dbPath.toString());
        config.setDriverClassName("org.sqlite.JDBC");
        config.setUsername("admin");
        config.setPassword("admin");
        config.setMaximumPoolSize(1);
        config.setConnectionTestQuery("SELECT 1");
        config.addDataSourceProperty("journal_mode", (Object)"WAL");
        return new HikariDataSource(config);
    }
}

