/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.utils.config;

import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration
public class WebClientConfig {
    @Bean
    public WebClient secureWebClient(WebClient.Builder builder) {
        return builder.exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x500000)).build()).defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Accept", new String[]{"application/json"}).build();
    }

    @Bean
    public WebClient insecureWebClient(WebClient.Builder builder) throws SSLException {
        HttpClient httpClient = HttpClient.create().secure(t -> {
            try {
                t.sslContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        });
        return builder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x500000)).build()).defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Accept", new String[]{"application/json"}).build();
    }
}

