/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.utils.util;

import com.miroit.sicksu.utils.util.BatRunner;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;

public class BatRunner {
    public Result runToggleBatByEnv(String batPathRelative, String instanceId, long delayMs) throws Exception {
        String output;
        Path batAbs = Paths.get(System.getProperty("user.dir"), new String[0]).resolve(batPathRelative).normalize().toAbsolutePath();
        ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", "call", batAbs.toString());
        pb.directory(new File(System.getProperty("user.dir")));
        pb.redirectErrorStream(true);
        pb.environment().put("DEVICE_INSTANCE_ID", instanceId.replace("\"", ""));
        pb.environment().put("DEVICE_TOGGLE_DELAY_MS", String.valueOf(delayMs));
        Process p = pb.start();
        try (InputStream is = p.getInputStream();){
            output = new String(is.readAllBytes(), Charset.forName("MS949"));
        }
        boolean done = p.waitFor(60L, TimeUnit.SECONDS);
        if (!done) {
            p.destroyForcibly();
            throw new RuntimeException("BAT timeout");
        }
        return new Result(p.exitValue(), output);
    }
}

