/*
 * Decompiled with CFR 0.152.
 */
package com.miroit.sicksu.utils.util;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;

public final class TimeUtil {
    public static String getNowMealType() {
        int hour = LocalDateTime.now().getHour();
        if (hour >= 6 && hour <= 10) {
            return "\uc870\uc2dd";
        }
        if (hour >= 11 && hour <= 15) {
            return "\uc911\uc2dd";
        }
        if (hour >= 16 && hour <= 20) {
            return "\uc11d\uc2dd";
        }
        return "\uc57c\uc2dd";
    }

    public static String getNowDateToString() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy.MM.dd"));
    }

    public static String getNowDateTimeToString() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss"));
    }

    public static String getStringFromDateTime(LocalDateTime dateTime) {
        return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static LocalTime getTimeFromString(String time) {
        return LocalTime.parse(time, DateTimeFormatter.ofPattern("HHmmss"));
    }

    public static LocalDateTime getDateTimeFromString(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss"));
    }

    public static boolean isBetweenTime(LocalTime start, LocalTime end, LocalTime targetTime) {
        return targetTime.isAfter(start) && targetTime.isBefore(end);
    }

    public static boolean isBetweenDateTime(LocalDateTime start, LocalDateTime end, LocalDateTime targetTime) {
        return targetTime.isAfter(start) && targetTime.isBefore(end);
    }

    @Generated
    private TimeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

